<?php

class EventPlus_Payments_Stripe extends EventPlus_Payments {

    private $jsSrc = 'https://checkout.stripe.com/checkout.js';

    protected function valid() {

        $valid = false;

        if (trim($this->companyOptions['secret_key']) != '' && trim($this->companyOptions['publishable_key']) != '') {
            $valid = true;
        }

        return $valid;
    }

    function submit() {
        ob_start();
        ?>
        <style>
            .stripe-button-el{display:none !important;}
            .stripe-button-el span{display:none !important;}
        </style>
        <form action="<?php echo $this->fields['stripe_process_url']; ?>" method="POST">
            <div>
                <?php
                $currency = $this->companyOptions['default_currency'];
                if ($this->fields['currency_code'] != '') {
                    $currency = $this->fields['currency_code'];
                }

                $amount = number_format($this->fields['amount'], 2);
                ?>
                <script src="<?php echo $this->jsSrc; ?>" class="stripe-button" 
                        data-key="<?php echo $this->companyOptions['publishable_key']; ?>"  
                        data-amount="<?php echo str_replace(".", "", $amount); ?>"  data-currency = "<?php echo "$currency"; ?>" />
                </script>
                <input type="hidden" name="amount" value="<?php echo $this->fields['amount']; ?>">
                <input type="hidden" name="token" value="<?php echo $this->fields['token']; ?>">
            </div>

            <input type="submit" id="registration_stripe_button" class="btn btn-sma77 btn-gr3y btn-ic0n paymen8" value="<?php _e('Pay Now', 'evrplus_language'); ?>">  
        </form>
        <?php
        return ob_get_clean();
    }

}
