<?php
/* * *****************************************************************************
 *                      PHP Paypal IPN Integration Class
 * ******************************************************************************
 *      Author:     Micah Carrick
 *      Email:      email@micahcarrick.com
 *      Website:    http://www.micahcarrick.com
 *
 *      File:       paypal.class.php
 *      Version:    1.3.0
 *      Copyright:  (c) 2005 - Micah Carrick 
 *                  You are free to use, distribute, and modify this software 
 *                  under the terms of the GNU General Public License.  See the
 *                  included license.txt file.
 *      
 * ******************************************************************************
 *  VERION HISTORY:
 *      v1.3.0 [10.10.2005] - Fixed it so that single quotes are handled the 
 *                            right way rather than simple stripping them.  This
 *                            was needed because the user could still put in
 *                            quotes.
 *  
 *      v1.2.1 [06.05.2005] - Fixed typo from previous fix :)
 *
 *      v1.2.0 [05.31.2005] - Added the optional ability to remove all quotes
 *                            from the paypal posts.  The IPN will come back
 *                            invalid sometimes when quotes are used in certian
 *                            fields.
 *
 *      v1.1.0 [05.15.2005] - Revised the form output in the submit_paypal_post
 *                            method to allow non-javascript capable browsers
 *                            to provide a means of manual form submission.
 *
 *      v1.0.0 [04.16.2005] - Initial Version
 *
 * ******************************************************************************
 *  DESCRIPTION:
 *
 *      NOTE: See www.micahcarrick.com for the most recent version of this class
 *            along with any applicable sample files and other documentaion.
 *
 *      This file provides a neat and simple method to interface with paypal and
 *      The paypal Instant Payment Notification (IPN) interface.  This file is
 *      NOT intended to make the paypal integration "plug 'n' play". It still
 *      requires the developer (that should be you) to understand the paypal
 *      process and know the variables you want/need to pass to paypal to
 *      achieve what you want.  
 *
 *      This class handles the submission of an order to paypal aswell as the
 *      processing an Instant Payment Notification.
 *  
 *      This code is based on that of the php-toolkit from paypal.  I've taken
 *      the basic principals and put it in to a class so that it is a little
 *      easier--at least for me--to use.  The php-toolkit can be downloaded from
 *      http://sourceforge.net/projects/paypal.
 *      
 *      To submit an order to paypal, have your order form POST to a file with:
 *
 *          $p = new paypal_class;
 *          $p->add_field('business', 'somebody@domain.com');
 *          $p->add_field('first_name', $_POST['first_name']);
 *          ... (add all your fields in the same manor)
 *          $p->submit_paypal_post();
 *
 *      To process an IPN, have your IPN processing file contain:
 *
 *          $p = new paypal_class;

 *          if ($p->validate_ipn()) {
 *          ... (IPN is verified.  Details are in the ipn_data() array)
 *          }
 *
 *
 *      In case you are new to paypal, here is some information to help you:
 *

 *      1. Download and read the Merchant User Manual and Integration Guide from
 *         http://www.paypal.com/en_US/pdf/integration_guide.pdf.  This gives 
 *         you all the information you need including the fields you can pass to
 *         paypal (using add_field() with this class) aswell as all the fields
 *         that are returned in an IPN post (stored in the ipn_data() array in
 *         this class).  It also diagrams the entire transaction process.
 *

 *      2. Create a "sandbox" account for a buyer and a seller.  This is just
 *         a test account(s) that allow you to test your site from both the 
 *         seller and buyer perspective.  The instructions for this is available
 *         at https://developer.paypal.com/ as well as a great forum where you
 *         can ask all your paypal integration questions.  Make sure you follow
 *         all the directions in setting up a sandbox test environment, including
 *         the addition of fake bank accounts and credit cards.
 * 
 * ******************************************************************************
 */

class EventPlus_Vendor_Paypal {

    var $last_error;                 // holds the last error encountered
    var $ipn_log;                    // bool: log IPN results to text file?
    var $ipn_log_file;               // filename of the IPN log
    var $ipn_response;               // holds the IPN response from paypal   
    var $ipn_data = array();         // array contains the POST values for IPN
    var $fields = array();           // array holds the fields to submit to paypal

    function __construct() {
        $this->last_error = '';
        $this->ipn_log_file = '.ipn_results.log';
        $this->ipn_log = true;
        $this->ipn_response = '';
        $this->add_field('rm', '2');          // Return method = POST
        $this->add_field('cmd', '_xclick');
        $this->add_field('charset', 'utf-8');
    }

    function add_field($field, $value) {

        $this->fields["$field"] = $value;
    }

    function submit($pay_text) {
        ?>

        <form method="post" name="paypal_form" action="<?php echo $this->paypal_url ?>">

            <?php
            foreach ($this->fields as $name => $value) {
                echo "<input type=\"hidden\" name=\"$name\" value=\"$value\"/>\n";
            }
            ?>

            <div class="rowdiv">
                <label><?php _e('Pay using PayPal', 'evrplus_language'); ?></label>
                <input type="submit" id="registration_payment_button" value="<?php _e('Pay Now', 'evrplus_language'); ?>">  
            </div>

        </form>
        <style>
            .rowdiv {
                clear: both;
                float: left;
                margin: 15px 0 0;
                width: 100%;
            }
            .rowdiv label {
                float: left;
                margin: 0 10px 0 0;
                padding: 4px 0;
            }
            #registration_payment_button{background-size:cover; background-position:center center; border:0; border: 0 none;
                                         float: left;
                                         font-size: 14px;
                                         height: 40px;
                                         width: 118px; }

            .stripe-button-el {
                background: transparent url("http://223.196.72.250/eventsplus/wp-content/themes/twentysixteen/images/stripbtn.png") no-repeat scroll center center / cover  !important;
                border: 0 none !important;
                border-radius: 7px !important;
                font-size: 0;
                height: 40px !important;
                width: 100px !important;
            }
            .stripe-button-el span{display:none !important;}
        </style>
        <?php
    }

    function validate_ipn() {
        $url_parsed = parse_url($this->paypal_url);
        $post_string = '';
        foreach ($_POST as $field => $value) {
            $this->ipn_data["$field"] = $value;
            $post_string .= $field . '=' . urlencode(stripslashes($value)) . '&';
        }
        $post_string.="cmd=_notify-validate"; // append ipn command

        $fp = fsockopen($url_parsed[host], "80", $err_num, $err_str, 30);

        if (!$fp) {

            $this->last_error = "fsockopen error no. $errnum: $errstr";
            $this->log_ipn_results(false);
            return false;
        } else {
            fputs($fp, "POST $url_parsed[path] HTTP/1.1\r\n");
            fputs($fp, "Host: $url_parsed[host]\r\n");
            fputs($fp, "Content-type: application/x-www-form-urlencoded\r\n");
            fputs($fp, "Content-length: " . strlen($post_string) . "\r\n");
            fputs($fp, "Connection: close\r\n\r\n");
            fputs($fp, $post_string . "\r\n\r\n");
            while (!feof($fp)) {
                $this->ipn_response .= fgets($fp, 1024);
            }
            fclose($fp); // close connection
        }
        if (eregi("VERIFIED", $this->ipn_response)) {
            $this->log_ipn_results(true);
            return true;
        } else {

            $this->last_error = 'IPN Validation Failed.';
            $this->log_ipn_results(false);
            return false;
        }
    }

    function log_ipn_results($success) {
        if (!$this->ipn_log) {
            return;
        } // is logging turned off?      
        // Timestamp
        $text = '[' . date('m/d/Y g:i A') . '] - ';

        if ($success) {
            $text .= "SUCCESS!\n";
        } else {
            $text .= 'FAIL: ' . $this->last_error . "\n";
        }
        // Log the POST variables
        $text .= "IPN POST Vars from Paypal:\n";
        foreach ($this->ipn_data as $key => $value) {
            $text .= "$key=$value, ";
        }
        // Log the response from the paypal server
        $text .= "\nIPN Response from Paypal Server:\n " . $this->ipn_response;
        $fp = fopen($this->ipn_log_file, 'a');
        fwrite($fp, $text . "\n\n");
        fclose($fp);  // close file
    }

    function dump_fields() {
        echo "
<table width=\"95%\" border=\"1\" cellpadding=\"2\" cellspacing=\"0\">
  <tr>
    <td bgcolor=\"black\"><b><font color=\"white\">Field Name</font></b></td>
    <td bgcolor=\"black\"><b><font color=\"white\">Value</font></b></td>
  </tr> ";
        ksort($this->fields);
        foreach ($this->fields as $key => $value) {
            echo "<tr>
    <td>$key</td>
    <td>" . urldecode($value) . "&nbsp;</td>
  </tr>";
        }
        echo "</table><br>";
    }

    function submit_stripe() {
        ?>
        <style>
            .rowdiv {
                clear: both;
                float: left;
                margin: 15px 0 0;
                width: 100%;
            }
            .rowdiv label {
                float: left;
                margin: 0 10px 0 0;
                padding: 4px 0;
            }
            #registration_payment_button{background:url(<?php echo bloginfo('template_url'); ?>/images/paypalBtn.png) no-repeat; background-size:cover; background-position:center center; border:0;font-size:0;border: 0 none;
                                         float: left;
                                         font-size: 0;
                                         height: 40px;
                                         width: 118px; }
            .stripe-button-el{display:none !important}
            /*.stripe-button-el */ 
            .stripe-buttonNew{
                background: transparent url("http://223.196.72.250/eventsplus/wp-content/themes/twentysixteen/images/stripbtn.png") no-repeat scroll center center / cover  !important;
                border: 0 none !important;
                border-radius: 7px !important;
                font-size: 0;
                height: 40px !important;
                width: 100px !important;
                font-size:0 !important;
            }
            .stripe-button-el span{display:none !important;}
        </style>
   
        <form action="<?php echo EVENT_PLUS_PUBLIC_URL; ?>stripe/payment.php" method="POST">
            <div class="rowdiv"><label><?php echo _e('Pay using your credit/debit card', 'evrplus_language'); ?></label>
                <?php
                $company_options2 = EventPlus_Models_Settings::getSettings();
                $currency = $company_options2['default_currency'];
                $amount = number_format($this->fields['amount'], 2);
                ?>
                <script src="https://checkout.stripe.com/checkout.js" class="stripe-button" 
                        data-key="<?php echo $company_options2['publishable_key']; ?>"  
                        data-amount="<?php echo str_replace(".", "", $amount); ?>"  data-currency = "<?php echo "$currency"; ?>" />
                </script>
                <input type="hidden" name="amount" value="<?php echo $this->fields['amount']; ?>">
                <input type="hidden" name="event_id" value="<?php echo (int) $_GET['event_id']; ?>">
            </div>
            <input type="submit" class="stripe-buttonNew" id="registration_stripe_button" value="<?php _e('Pay via Stripe', 'evrplus_language'); /* changed by david fleming to make customizable */ ?>">  

        </form>

        <?php
    }

}
